<?php

/* * **********************************************************************
 * Generate EMAS standard PHP extensions list for specific PHP version
 * This script retrieves the list of installed PHP extensions and saves it
 * in a JSON file for later use.
 * This is useful for ensuring compatibility and standardization across
 * servers
 * 
 * URL to run this script: http://<yourserver.com>/<libfolder>/gen-php-extensions-list.php?phpversion?listtype=<type> where type is "list" or "json"
 * The version numbers will be fetched by theapp
 * Example: http://systemdev.emastpa.com.my/emasphputils/gen-php-extensions-list.php?listtype=json
 **************************************************************************/
$debug    = false;
$debug1   = true;
$listType = isset($_GET['listtype']) ? $_GET['listtype'] : 'list'; // ~ Default to 'list' if not set

// ~ Get the PHP Version number set for the server/domain
$version    = phpversion();           // e.g., "8.2.10"
$parts      = explode('.', $version);   // ["8", "2", "10"]
$phpVersion = $parts[0] . '.' . $parts[1];

if ($debug) {
    echo "<pre>";
    echo "PHP Version: $phpVersion<br/>";
    echo "</pre>";
    die;
}

echo "<pre>";
echo "Generating Extensions Lists for PHP $phpVersion <br/>";
echo "-----------------------------------------<br/>";
echo "</pre>";

// ~Get list of installed PHP extensions
$installedExtensions = get_loaded_extensions();

if ($listType === 'list') {
    // ~ Print extensions to verify or save to a file
    echo "<pre>";
    echo "List of extensions detected<br/>";
    echo "---------------------------<br/>";
    echo var_dump($installedExtensions) . "<br  />"; // Output to screen
    echo "---------------------------<br/>";
    echo "</pre>";
} else {
    $filename = "extensions-list-PHP{$phpVersion}.json";
    file_put_contents($filename, json_encode($installedExtensions));

    echo "<pre>";
    echo "Generated Extensions List Generated for PHP $phpVersion <br/>";
    echo "--------------------------------------------------------<br/>";
    echo "</pre>";
}










